/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: HexEdit.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 4.07.06 16:23 $
    $Revision: 1353 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Edit Control supporting hexadecimal entries
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        04.07.2006  MT       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file HexEdit.h
///   Edit Control supporting hexadecimal entries
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include <stdint.h>

///////////////////////////////////////////////////////////////////////////////////////////
/// Edit Control supporting hexadecimal entries
///////////////////////////////////////////////////////////////////////////////////////////
class CHexEdit : public CEdit
{
	DECLARE_DYNAMIC(CHexEdit)

public:
	CHexEdit();
	virtual ~CHexEdit();

protected:
	DECLARE_MESSAGE_MAP()

  bool                        m_fDisplayHex;          //!< true if value is displayed in hexadecimal notation
  unsigned long               m_ulHexWidth;           //!< Width of the hexadecimal notation

  bool                        m_fForceHexConversion;  //!< Force inputs to be handled as hexadecimal
  unsigned long               m_ulValue;              //!< Current value of the control
  __unaligned uint32_t*       m_pulValue;             //!< Pointer to a variable receiving updated values

public:
  afx_msg void OnEnChange();
  void         Update(void);

  bool GetViewStyle(void)
  {
    return m_fDisplayHex;
  }

  void  SetViewStyle(bool fHex = true)
  {
    m_fDisplayHex = fHex;
    Update();
  }

  unsigned long GetHexWidth(void)
  {
    return m_ulHexWidth;
  }

  void SetHexWidth(unsigned long ulNewWidth)
  {
    m_ulHexWidth = ulNewWidth;
    Update();
  }

  unsigned long GetValue(void)
  {
    return m_ulValue;
  }

  void SetValue(unsigned long ulNewValue)
  {
    m_ulValue = ulNewValue;
    if(m_pulValue != NULL)
      *m_pulValue = ulNewValue;
    Update();
  }

  void SetUpdateVariable(__unaligned uint32_t* pulVarToSet)
  {
    m_pulValue = pulVarToSet;
    SetValue(m_ulValue);
  }

  afx_msg void OnEnKillfocus();
};


